#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Mandelbulb z^12Mod01.fsh  by   DarthNOdlehS   
//https://www.shadertoy.com/view/...
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/* by DarthNOdlehS */
#define DOSXPI 6.283185307 
#define NUM_ITERS 99		// number interations
#define D_MIN 0.0001		// distance min 0.0001
#define D_MAX 100.0			// distance max 100.0
#define CONTROL 1.0
#define M_EXP  12.0

float _z_pos = -2.0;

vec3 hsv_to_rgb(vec3 hsv){
	float hue_col = 6.0 * fract(hsv.x); 
	float r = -1.0 + abs(hue_col - 3.0);
	float g =  2.0 - abs(hue_col - 2.0);
	float b =  2.0 - abs(hue_col - 4.0);
	vec3 rgb = clamp(vec3(r, g, b),0.0,1.0); 	//hue
	rgb = mix(vec3(1.0), rgb, hsv.y); 			//saturation
	return rgb * hsv.z; 						//value
}

vec2 rotation(float argo, float prima, float secua){
	float s = sin(argo);
	float c = cos(argo);
	return vec2(prima * c + secua * s, -prima * s + secua * c);
}

float distance_to_mb( vec3 r3d ){     // BULB z ^ M
	r3d.xy = rotation(DOSXPI*sin(iTime*0.03),r3d.x, r3d.y);
	r3d.yz = rotation(DOSXPI*cos(iTime*0.03),r3d.y, r3d.z);
	float mxthe, mxphi, rexpm, sinthe, radius;
	vec3 zn = r3d;
	float df = 1.0;

	for( int i = 0; i < 10; i++ ){
		radius = length( zn );
		if( radius > 2.0 )	
			break;				
		mxthe = M_EXP*atan( length( zn.xy ), zn.z ); // M x theta
		mxphi = M_EXP*atan( zn.y, zn.x );			 // M x phi
		rexpm = pow(radius,M_EXP);					 // r ^ M
		sinthe=sin(mxthe); 
		zn = rexpm * vec3(sinthe * cos(mxphi), sinthe * sin(mxphi), cos(mxthe)) + r3d;  
		df = M_EXP * pow(radius, M_EXP-1.0) * df + CONTROL; 
	}
	return 0.5 * log(radius) * radius / df;			// final distance aprox
}
vec2 ray_marching_plus(vec3 p_ini, vec3 u_raymar_dir){	
	float deep=0.0;
	float delta=0.0;
	int i;
	for(i=0; i<NUM_ITERS; i++){
		delta = distance_to_mb(p_ini + deep * u_raymar_dir);
		if ( delta < D_MIN) 
			break;		 
		deep += delta;
	}
	return vec2(deep, i);  
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv =  (fragCoord-0.5*iResolution.xy)/iResolution.yy;  
	vec3 p_ini=vec3(0.0, 0.0, _z_pos + 0.7* sin(iTime*0.3));  // camera pos
	vec3 u_raymar_dir = normalize(vec3(uv.x, uv.y ,1.0));     //ray marching direction
	vec2 deepi = ray_marching_plus(p_ini, u_raymar_dir);
	vec3 pos3d = p_ini + deepi.x * u_raymar_dir;	
	vec3 col =hsv_to_rgb(vec3(0.1 - length(pos3d), 0.8, 10.0/deepi.y)); 
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

